/* 
 *  UUITab.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient;

import java.util.Optional;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;

public class UUITab extends UUITabBase {

    private final Button save;
    private final InteractionExecutor interactionExe;
    private final InteractionDataGUI gui;
    private static final Logger LOG = Logger.getLogger(UUITab.class);

    public UUITab(InteractionExecutor interactionExe, InteractionDataGUI gui) {
        this.interactionExe = interactionExe;
        this.gui = gui;

        HBox buttons = new HBox();
        save = new Button("Save");
        save.setDisable(true);
        save.getStyleClass().add("intrinsicButton");
        save.setOnAction((ActionEvent t) -> {
            String text = uuiEditor.getText();
            LOG.info("SaveButton() Text:" + text);
            saveUUIDialog(text);
        });

        buttons.getChildren().addAll(save);
        uuiPane.setBottom(buttons);
    }

    private void saveUUIDialog(String newUUI) {
        Dialog<String> dialog = new Dialog<>();
        dialog.setTitle("Save UUI");

        ButtonType saveButtonType = new ButtonType("Save", ButtonBar.ButtonData.OK_DONE);
        dialog.getDialogPane().getButtonTypes().addAll(saveButtonType, ButtonType.CANCEL);

        GridPane grid = new GridPane();
        grid.getStyleClass().add("dialog");

        TextField uui = new TextField();
        uui.setText(newUUI);

        grid.add(new Label("UUI:"), 0, 0);
        grid.add(uui, 1, 0);

        dialog.getDialogPane().setContent(grid);

        Platform.runLater(() -> uui.requestFocus());

        dialog.setResultConverter(dialogButton -> {
            if (dialogButton == saveButtonType) {
                return uui.getText();
            }
            return null;
        });

        Optional<String> result = dialog.showAndWait();

        result.ifPresent(uuiResult -> {
            String methodName = "saveUUIDialog() ";
            LOG.trace(methodName + " UUI:" + uuiResult);
            interactionExe.setUUI(gui.getCurrentItemSelection().getId(), uuiResult);
        });
    }

    @Override
    void update(InteractionDataI data) {
        String methodName = "update() ";
        LOG.trace(methodName + "+");

//        boolean disable = !data.canGetUUI();
        boolean disable = false;
        LOG.trace(methodName + "disable = " + disable);
        this.tab.setDisable(disable);
        this.uuiEditor.setDisable(disable);
        this.save.setDisable(!data.canSetUUI());

        String uuiData = data.getUui();
        if (uuiData != null) {
            LOG.trace(methodName + "UUI:" + uuiData);
            uuiEditor.setText(uuiData);
        } else {
            LOG.trace(methodName + "setting blank txt");
            uuiEditor.setText(BLANKUUI);
        }
        LOG.trace(methodName + "-");
    }
}
